//==============================================================================
// Project:		Wealth Transfers and their Economic Effects
// File name:	Merging Aggregate Wealth Current Datasets
// Objective: 	Combining the aggregate wealth statistics from each of the four
//				data sources
//
// Created: 	31/03/2021
// Modified: 	15/11/2021
//==============================================================================

clear

cd "XXXX"	// set the content directory here

use "HILDA Aggregate Wealth Current"	// opening the data

keep year wt*	// keeping key variables

local wealth_vars wt*	// creating a local wealth variables macro

* renaming HILDA variables
foreach w in `wealth_vars' {
    rename `w' hilda_`w'
}

gen month = 6	// generating a month variable equal to six

merge 1:1 year month using "ASNA Quarterly Wealth Current", nogen	// merging in National Accounts data

merge 1:1 year month using "SIH Aggregate Wealth Current", nogen	// merging in SIH data

local sih_wealth_vars wt*	// creating a local macro including SIH variables

* renaming SIH variables
foreach w in `wealth_vars' {
    rename `w' sih_`w'
}

drop if year == 2021	// dropping 2021 variables

local asna_wealth_vars asna_consumer_durables asna_f_assets asna_fa_cad asna_fa_itro asna_fa_itrs asna_fa_lap asna_fa_oar asna_fa_saoe asna_fa_sots asna_l_lap asna_l_oap asna_l_sots asna_liabilities asna_net_worth asna_nf_assets asna_nf_npa asna_nf_npa_nr_l asna_nf_npa_nr_nst asna_nf_pa asna_nf_pa_i asna_nf_pa_i_f asna_nf_pa_i_pnf asna_nf_pa_i_pst asna_nf_pfa asna_nf_pfa_cbr asna_nf_pfa_d asna_nf_pfa_ipp asna_nf_pfa_mae asna_nf_pfa_ndc asna_nf_pfa_otc asna_res_land_dwel asna_total_assets	// creating a local macro including National Accounts wealth variables

foreach w in `asna_wealth_vars' {
	replace `w' = `w' * 1000000000
}	// original data was reported in billions

replace sih_wt_pop_wealthh = . if sih_wt_pop_wealthh == 0	// replacing zeroes as missing

* generating a data variable
gen day = 1
gen edate = mdy(month, day, year)
format edate %d

save "Combined Aggregate Wealth Current", replace	// saving the dataset

* dropping non-2018 variables
drop _merge
drop if year != 2018
drop if month != 6